; Script generated by the Inno Setup Script Wizard.
; SEE THE DOCUMENTATION FOR DETAILS ON CREATING INNO SETUP SCRIPT FILES!

;-------------------------------------------------------------------------------

; This file is part of Code_Saturne, a general-purpose CFD tool.
;
; Copyright (C) 1998-2016 EDF S.A.
;
; This program is free software; you can redistribute it and/or modify it under
; the terms of the GNU General Public License as published by the Free Software
; Foundation; either version 2 of the License, or (at your option) any later
; version.
;
; This program is distributed in the hope that it will be useful, but WITHOUT
; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
; FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
; details.
;
; You should have received a copy of the GNU General Public License along with
; this program; if not, write to the Free Software Foundation, Inc., 51 Franklin
; Street, Fifth Floor, Boston, MA 02110-1301, USA.

;-------------------------------------------------------------------------------

#define MyAppName "Code_Saturne"
#define MyAppVersion "4.1"
#define MyAppVersionFull "4.1.4"
#define MyAppVersionShort "4.1"
#define MyAppPublisher "EDF"
#define MyAppCopyright "Copyright (C) 1998-2016 EDF S.A."
#define MyAppURL "http://www.code-saturne.org/"
#define MyAppExeName "code_saturne.exe"

#define HAVE_CGNS "yes"
#define HAVE_HDF5 "yes"
#define HAVE_LIBXML2 "yes"
#define HAVE_MED "yes"
#define HAVE_METIS "yes"
#define HAVE_MPI "yes"
#define HAVE_SCOTCH "yes"

#define HAVE_SALOME "yes"

#define GCC_VERSION "4.4.5"
#define PYTHON_VERSION ""

#define Install ""
#define Cygwin "C:\cygwin"
#define CxFreeze "\build\exe.win32-" + PYTHON_VERSION

#ifexist Install + "\share\doc\code_saturne\user.pdf"
  #define HAVE_PDF "yes"
#else
  #define HAVE_PDF "no"
#endif
#ifexist Install + "\share\doc\code_saturne\doxygen\src\index.html"
  #define HAVE_DOXYGEN "yes"
#else
  #define HAVE_DOXYGEN "no"
#endif
#ifexist Install + "\share\doc\salome\gui\CFDSTUDY\index.html"
  #define HAVE_SPHINX "yes"
#else
  #define HAVE_SPHINX "no"
#endif
#ifexist Install + "\share\locale\fr\LC_MESSAGES\code_saturne.mo"
  #define HAVE_LOCALE "yes"
#else
  #define HAVE_LOCALE "no"
#endif

;-------------------------------------------------------------------------------

[Setup]
; NOTE: The value of AppId uniquely identifies this application.
; Do not use the same AppId value in installers for other applications.
; (To generate a new GUID, click Tools | Generate GUID inside the IDE.)
AppId={{51C212F8-B939-4F9C-A67B-5532202851BD}
AppName={#MyAppName}
AppVersion={#MyAppVersionFull}
AppVerName={#MyAppName} {#MyAppVersion}
AppPublisher={#MyAppPublisher}
AppPublisherURL={#MyAppURL}
AppSupportURL={#MyAppURL}
AppUpdatesURL={#MyAppURL}
DefaultDirName={pf}\{#MyAppName}\{#MyAppVersionShort}
DefaultGroupName={#MyAppName} {#MyAppVersionShort}
LicenseFile={#Install}\share\code_saturne\COPYING
OutputBaseFilename={#MyAppName} {#MyAppVersionFull} win32
Compression=lzma
SolidCompression=yes

;-------------------------------------------------------------------------------

[Languages]
Name: "english"; MessagesFile: "compiler:Default.isl"
Name: "french"; MessagesFile: "compiler:Languages\French.isl"

;-------------------------------------------------------------------------------

[Components]
Name: "core"; Description: "Code_Saturne main files"; Types: full compact custom; Flags: checkablealone fixed
#if HAVE_SALOME == "yes"
Name: "salome"; Description: "Code_Saturne SALOME plugin"; Types: full
#endif
Name: "help"; Description: "Code_Saturne Help files"; Types: full compact
#if HAVE_PDF == "yes"
Name: "help\pdf"; Description: "Documentation manuals"; Types: full compact
#endif
#if HAVE_DOXYGEN == "yes"
Name: "help\doxygen"; Description: "Source code documentation"; Types: full compact
#endif
Name: "dev"; Description: "Development tools, headers and libraries"; Types: full compact custom; Flags: checkablealone fixed
Name: "dev\saturne"; Description: "Code_Saturne"; Types: full compact custom; Flags: checkablealone fixed
Name: "dev\system"; Description: "System files"; Types: full compact custom; Flags: checkablealone fixed
Name: "dev\binutils"; Description: "GNU Binutils"; Types: full compact custom; Flags: checkablealone fixed
Name: "dev\gcc"; Description: "GNU Compiler Collection"; Types: full compact custom; Flags: checkablealone fixed
#if HAVE_CGNS == "yes"
Name: "dev\cgns"; Description: "CGNS"; Types: full compact custom; Flags: checkablealone fixed
#define CGNSPATH ""
#endif
#if HAVE_HDF5 == "yes"
Name: "dev\hdf5"; Description: "HDF5"; Types: full compact custom; Flags: checkablealone fixed
#define HDF5PATH ""
#endif
#if HAVE_LIBXML2 == "yes"
Name: "dev\libxml2"; Description: "LibXML2"; Types: full compact custom; Flags: checkablealone fixed
#define LIBXML2PATH ""
#endif
#if HAVE_MED == "yes"
Name: "dev\med"; Description: "MED"; Types: full compact custom; Flags: checkablealone fixed
#define MEDPATH ""
#endif
#if HAVE_METIS == "yes"
Name: "dev\metis"; Description: "Metis"; Types: full compact custom; Flags: checkablealone fixed
#define METISPATH ""
#endif
#if HAVE_MPI == "yes"
Name: "dev\mpi"; Description: "MPI"; Types: full compact custom; Flags: checkablealone fixed
#define MPIPATH ""
#endif
#if HAVE_SCOTCH == "yes"
Name: "dev\scotch"; Description: "Scotch"; Types: full compact custom; Flags: checkablealone fixed
#define SCOTCHPATH ""
#endif

;-------------------------------------------------------------------------------

[Tasks]
Name: "desktopicon"; Description: "{cm:CreateDesktopIcon}"; GroupDescription: "{cm:AdditionalIcons}"

;-------------------------------------------------------------------------------

[Files]
; NOTE: Don't use "Flags: ignoreversion" on any shared system files
; Low-level dependencies (zlib, gettext, pthread, ...)
Source: "{#Cygwin}\bin\cygiconv-2.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\bin\cygintl-8.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\bin\cygz.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\zlib1.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\libwinpthread-1.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\liblzma-5.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
; Windows CRT DLL
Source: "C:\Windows\System32\msvcrt.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "C:\Windows\System32\msvcr100.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "C:\Windows\System32\msvcr100.dll"; DestDir: "{app}\libexec\code_saturne"; Flags: ignoreversion; Components: core
Source: "C:\Windows\System32\msvcr100.dll"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: core
; GCC runtime
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\libgcc_s_sjlj-1.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\libgcc_s_sjlj-1.dll"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\libgfortran-3.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\libquadmath-0.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\libquadmath-0.dll"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: core
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\libstdc++-6.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
; GCC executables
Source: "{#Cygwin}\bin\cpp.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\g++.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\gcc.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\gfortran.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\i686-w64-mingw32-cpp.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\i686-w64-mingw32-c++.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\i686-w64-mingw32-g++.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\i686-w64-mingw32-gfortran.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\i686-w64-mingw32-gcc.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\bin\libgomp-1.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\cyggmp-10.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\cyggmpxx-4.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\cygmpc-3.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\cygmpfr-4.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\cygstdc++-6.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\cyggcc_s-1.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\bin\cygwin1.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\lib\gcc\i686-w64-mingw32\{#GCC_VERSION}\*.*"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\lib\gcc\i686-w64-mingw32\{#GCC_VERSION}\include\*"; DestDir: "{app}\include"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: dev\gcc
Source: "{#Cygwin}\lib\gcc\i686-w64-mingw32\{#GCC_VERSION}\*"; DestDir: "{app}\lib\gcc\i686-w64-mingw32\{#GCC_VERSION}"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libadvapi32.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libkernel32.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libuser32.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libshell32.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libz.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libm.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\gcc
Source: "{#Cygwin}\usr\i686-w64-mingw32\bin\*"; DestDir: "{app}\lib\gcc\i686-w64-mingw32\{#GCC_VERSION}"; Flags: ignoreversion; Components: dev\gcc
; Binutils
Source: "{#Cygwin}\bin\addr2line.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\bin\c++filt.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\bin\dllwrap.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\bin\elfedit.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\bin\gprof.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\bin\readelf.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\bin\size.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\bin\strings.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\bin\windmc.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\bin\windres.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\usr\include\ansidecl.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\usr\include\bfd.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\usr\include\bfdlink.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\usr\include\dis-asm.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\usr\include\symcat.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\lib\libbfd.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\lib\libiberty.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\binutils
Source: "{#Cygwin}\lib\libopcodes.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\binutils
; Cygwin system headers and libraries
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\include\*"; DestDir: "{app}\include"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\*.o"; DestDir: "{app}\lib\gcc\i686-w64-mingw32\{#GCC_VERSION}"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libcrtdll.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libgmon.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libm.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmingw32.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmingwex.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmingwthrd.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmoldname.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmsvcr100.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmsvcr110.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmsvcr80.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmsvcr90.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmsvcr90d.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
Source: "{#Cygwin}\usr\i686-w64-mingw32\sys-root\mingw\lib\libmsvcrt.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\system
; Pre-requisites
#if HAVE_CGNS == "yes"
Source: "{#CGNSPATH}\include\cgns_io.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\cgns
Source: "{#CGNSPATH}\include\cgnslib.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\cgns
Source: "{#CGNSPATH}\include\cgnstypes.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\cgns
Source: "{#CGNSPATH}\lib\libcgns.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\cgns
#endif
#if HAVE_HDF5 == "yes"
Source: "{#HDF5PATH}\include\hdf5.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\hdf5
Source: "{#HDF5PATH}\include\H5*.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\hdf5
;Source: "{#HDF5PATH}\lib\libhdf5.dll.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\hdf5
Source: "{#HDF5PATH}\lib\libhdf5.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\hdf5
#endif
#if HAVE_LIBXML2 == "yes"
Source: "{#LIBXML2PATH}\bin\libxml2-2.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#LIBXML2PATH}\include\libxml2\*"; DestDir: "{app}\include\libxml2"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: dev\libxml2
Source: "{#LIBXML2PATH}\lib\libxml2.dll.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\libxml2
#endif
#if HAVE_MED == "yes"
Source: "{#MEDPATH}\include\med.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\med
Source: "{#MEDPATH}\include\med_proto.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\med
Source: "{#MEDPATH}\lib\libmedC.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\med
#endif
#if HAVE_METIS == "yes"
Source: "{#METISPATH}\bin\libmetis.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#METISPATH}\include\metis.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\metis
Source: "{#METISPATH}\lib\libmetis.dll.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\metis
#endif
#if HAVE_MPI == "yes"
Source: "{#MPIPATH}\lib\msmpi.dll"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: core
Source: "{#MPIPATH}\include\mpi.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\mpi
Source: "products\MSMpiSetup.exe"; DestDir: {tmp}; Flags: deleteafterinstall
#endif
#if HAVE_SCOTCH == "yes"
Source: "{#SCOTCHPATH}\include\scotch.h"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\scotch
Source: "{#SCOTCHPATH}\lib\libscotch.a"; DestDir: "{app}\libexec\code_saturne"; Flags: ignoreversion; Components: dev\scotch
Source: "{#SCOTCHPATH}\lib\libscotch.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\scotch
Source: "{#SCOTCHPATH}\lib\libscotcherr.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\scotch
Source: "{#SCOTCHPATH}\lib\libscotcherrexit.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\scotch
Source: "{#SCOTCHPATH}\lib\libscotchmetis.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\scotch
#endif
; Code_Saturne
Source: "{#Install}\etc\code_saturne.cfg.template"; DestDir: "{commonappdata}\{#MyAppName}\{#MyAppVersionShort}"; DestName: "code_saturne.ini"; Flags: onlyifdoesntexist; Components: core
Source: "{#Install}\etc\code_saturne.cfg.template"; DestDir: "{userappdata}\{#MyAppName}\{#MyAppVersionShort}"; DestName: "code_saturne.ini"; Flags: onlyifdoesntexist; Components: core
Source: "{#Install}\include\code_saturne\*"; DestDir: "{app}\include\code_saturne"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: dev\saturne
Source: "{#Install}\include\ple_*"; DestDir: "{app}\include"; Flags: ignoreversion; Components: dev\saturne
Source: "{#Install}\lib\libple.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\saturne
Source: "{#Install}\lib\libsaturne.a"; DestDir: "{app}\lib"; Flags: ignoreversion; Components: dev\saturne
Source: "{#Install}\libexec\code_saturne\cs_check_syntax.exe"; DestDir: "{app}\libexec\code_saturne"; Flags: ignoreversion; Components: core
Source: "{#Install}\libexec\code_saturne\cs_io_dump.exe"; DestDir: "{app}\libexec\code_saturne"; Flags: ignoreversion; Components: core
Source: "{#Install}\libexec\code_saturne\cs_preprocess.exe"; DestDir: "{app}\libexec\code_saturne"; Flags: ignoreversion; Components: core
Source: "{#Install}\libexec\code_saturne\cs_solver.exe"; DestDir: "{app}\libexec\code_saturne"; Flags: ignoreversion; Components: core
Source: "{#Install}\share\code_saturne\*"; DestDir: "{app}\share\code_saturne"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: core
#if HAVE_PDF == "yes"
Source: "{#Install}\share\doc\code_saturne\autovnv.pdf"; DestDir: "{app}\share\doc\code_saturne"; Flags: ignoreversion; Components: help\pdf
Source: "{#Install}\share\doc\code_saturne\developer.pdf"; DestDir: "{app}\share\doc\code_saturne"; Flags: ignoreversion; Components: help\pdf
Source: "{#Install}\share\doc\code_saturne\install.pdf"; DestDir: "{app}\share\doc\code_saturne"; Flags: ignoreversion; Components: help\pdf
Source: "{#Install}\share\doc\code_saturne\refcard.pdf"; DestDir: "{app}\share\doc\code_saturne"; Flags: ignoreversion; Components: help\pdf
Source: "{#Install}\share\doc\code_saturne\theory.pdf"; DestDir: "{app}\share\doc\code_saturne"; Flags: ignoreversion; Components: help\pdf
Source: "{#Install}\share\doc\code_saturne\user.pdf"; DestDir: "{app}\share\doc\code_saturne"; Flags: ignoreversion; Components: help\pdf
#endif
#if HAVE_DOXYGEN == "yes"
Source: "{#Install}\share\doc\code_saturne\doxygen\src\*"; DestDir: "{app}\share\doc\code_saturne\doxygen\src"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: help\doxygen
#endif
#if HAVE_LOCALE == "yes"
Source: "{#Install}\share\locale\*"; DestDir: "{app}\share\locale"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: core
#endif
; Graphical user interface (generated by cx_freeze)
Source: "{#CxFreeze}\code_saturne.com"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\code_saturne.exe"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\_hashlib.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\_socket.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\_ssl.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\bz2.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\library.zip"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\pyexpat.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\PyQt4.Qtcore.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\PyQt4.QtGui.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\python27.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\Qtcore4.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\QtGui4.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\select.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\sip.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\unicodedata.pyd"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: core
Source: "{#CxFreeze}\translations\*"; DestDir: "{app}\translations"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: core
; SALOME plugin
#if HAVE_SALOME == "yes"
Source: "{#Install}\bin\SalomeIDLCFDSTUDY-0.dll"; DestDir: "{app}\bin"; Flags: ignoreversion; Components: salome
Source: "{#Install}\lib\python{#PYTHON_VERSION}\site-packages\code_saturne\*"; DestDir: "{app}\lib\python{#PYTHON_VERSION}\site-packages\code_saturne"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: salome
Source: "{#Install}\lib\python{#PYTHON_VERSION}\site-packages\salome\*"; DestDir: "{app}\lib\python{#PYTHON_VERSION}\site-packages\salome"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: salome
Source: "{#Install}\lib\salome\SalomeIDLCFDSTUDY.dll.lib"; DestDir: "{app}\lib\salome"; Flags: ignoreversion; Components: salome
Source: "{#Install}\share\salome\resources\cfdstudy\*"; DestDir: "{app}\share\salome\resources\cfdstudy"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: salome
#if HAVE_SPHINX == "yes"
Source: "{#Install}\share\doc\salome\gui\CFDSTUDY\*"; DestDir: "{app}\share\doc\salome\gui\CFDSTUDY"; Flags: ignoreversion recursesubdirs createallsubdirs; Components: salome
#endif
#endif

;-------------------------------------------------------------------------------

[Icons]
Name: "{group}\{#MyAppName}"; Filename: "{app}\bin\{#MyAppExeName}"
Name: "{group}\{cm:ProgramOnTheWeb,{#MyAppName}}"; Filename: "{#MyAppURL}"
Name: "{commondesktop}\{#MyAppName}"; Filename: "{app}\bin\{#MyAppExeName}"; WorkingDir: "{userdesktop}"; Tasks: desktopicon
#if HAVE_PDF == "yes"
Name: "{group}\theory.pdf"; Filename: "{app}\share\doc\code_saturne\theory.pdf"
Name: "{group}\autovnv.pdf"; Filename: "{app}\share\doc\code_saturne\autovnv.pdf"
Name: "{group}\refcard.pdf"; Filename: "{app}\share\doc\code_saturne\refcard.pdf"
Name: "{group}\theory.pdf"; Filename: "{app}\share\doc\code_saturne\theory.pdf"
Name: "{group}\user.pdf"; Filename: "{app}\share\doc\code_saturne\user.pdf"
#endif
#if HAVE_DOXYGEN == "yes"
Name: "{group}\doxygen"; Filename: "{app}\share\doc\code_saturne\doxygen\src\index.html"
#endif

;-------------------------------------------------------------------------------

[Run]
Filename: "{tmp}\MSMpiSetup.exe"; Parameters: " -full -unattend"; StatusMsg: "Installing MSMpi..."; Check: MyProgCheck
Filename: "{app}\bin\{#MyAppExeName}"; WorkingDir: "{userdesktop}"; Flags: nowait postinstall skipifsilent; Description: "{cm:LaunchProgram,{#StringChange(MyAppName, '&', '&&')}}"

;-------------------------------------------------------------------------------

[Code]
function MyProgCheck(): Boolean;
begin
  Result := True;
  //vérif si besoin d'installer en cherchant dans le registre
  if RegKeyExists(HKEY_CURRENT_USER, 'SOFTWARE\Microsoft\MPI') then
  begin
     Result := False;
  end;
end;

