<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile>
  <compound kind="file">
    <name>ple_coupling.c</name>
    <path>/home/D43345/Code_Saturne/saturne-4.1/libple/src/</path>
    <filename>ple__coupling_8c</filename>
    <member kind="function">
      <type>int</type>
      <name>ple_coupling_mpi_name_to_id</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>ac2d0411ec817c0a5bcccebd776a60022</anchor>
      <arglist>(MPI_Comm comm, const char *group_name)</arglist>
    </member>
    <member kind="function">
      <type>ple_coupling_mpi_set_t *</type>
      <name>ple_coupling_mpi_set_create</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>a80f173979407ece0469ceab8306f4d7b</anchor>
      <arglist>(int sync_flag, const char *app_type, const char *app_name, MPI_Comm base_comm, MPI_Comm app_comm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_coupling_mpi_set_destroy</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>a9bc5a989d473653d67319b1b6fbe5e5b</anchor>
      <arglist>(ple_coupling_mpi_set_t **s)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ple_coupling_mpi_set_n_apps</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>a45789ac9c482c1a136d15567bbbf330e</anchor>
      <arglist>(const ple_coupling_mpi_set_t *s)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ple_coupling_mpi_set_get_app_id</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>a3cc64ea6576822a4064d4e1f1c2d6cc8</anchor>
      <arglist>(const ple_coupling_mpi_set_t *s)</arglist>
    </member>
    <member kind="function">
      <type>ple_coupling_mpi_set_info_t</type>
      <name>ple_coupling_mpi_set_get_info</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>acb673c1c88719869b369f4226049b899</anchor>
      <arglist>(const ple_coupling_mpi_set_t *s, int app_id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_coupling_mpi_set_synchronize</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>a511ea3983774674052c85c78966843a0</anchor>
      <arglist>(ple_coupling_mpi_set_t *s, int sync_flag, double time_step)</arglist>
    </member>
    <member kind="function">
      <type>const int *</type>
      <name>ple_coupling_mpi_set_get_status</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>ae452854eea5fd7edc889d9afebc72396</anchor>
      <arglist>(const ple_coupling_mpi_set_t *s)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>ple_coupling_mpi_set_get_timestep</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>a47cbdc88f914f20c0ba3901b7ec0386c</anchor>
      <arglist>(const ple_coupling_mpi_set_t *s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_coupling_mpi_intracomm_create</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>a82c14c912b7e5b89c52a3a14eab474c9</anchor>
      <arglist>(MPI_Comm base_comm, MPI_Comm app_comm, int distant_root, MPI_Comm *new_comm, int local_range[2], int distant_range[2])</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_coupling_mpi_set_dump</name>
      <anchorfile>ple__coupling_8c.html</anchorfile>
      <anchor>a5bb8157255bd269d788c22111bd1f090</anchor>
      <arglist>(const ple_coupling_mpi_set_t *s)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ple_defs.c</name>
    <path>/home/D43345/Code_Saturne/saturne-4.1/libple/src/</path>
    <filename>ple__defs_8c</filename>
    <member kind="function">
      <type>int</type>
      <name>ple_printf</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>a564e6e016e0b0763ba4888c1a33c8ba9</anchor>
      <arglist>(const char *const format,...)</arglist>
    </member>
    <member kind="function">
      <type>ple_printf_t *</type>
      <name>ple_printf_function_get</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>ad81909a66b36b8e6cc4034f364c0a42a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_printf_function_set</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>a2078a93eadcdae80a4bf2744358d6dc4</anchor>
      <arglist>(ple_printf_t *const fct)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_error</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>a447358bc1c2ad3f68e56e6e2beb75947</anchor>
      <arglist>(const char *const file_name, const int line_num, const int sys_error_code, const char *const format,...)</arglist>
    </member>
    <member kind="function">
      <type>ple_error_handler_t *</type>
      <name>ple_error_handler_get</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>ac94318f5092b467aa64a1629b44f6a94</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_error_handler_set</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>a8f1cecc343e231b9826d7e211d9e42f8</anchor>
      <arglist>(ple_error_handler_t *handler)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>ple_mem_malloc</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>aab73d5f565ba18445b39625f36825cfa</anchor>
      <arglist>(size_t ni, size_t size, const char *var_name, const char *file_name, int line_num)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>ple_mem_realloc</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>ab391c179a7cadb3f11a8eb265f723fb0</anchor>
      <arglist>(void *ptr, size_t ni, size_t size, const char *var_name, const char *file_name, int line_num)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>ple_mem_free</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>a936714011bb63007b68266c69f5f6410</anchor>
      <arglist>(void *ptr, const char *var_name, const char *file_name, int line_num)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_mem_functions_get</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>a31b0f2af0f176cabd2b358d924dea6e9</anchor>
      <arglist>(ple_mem_malloc_t **malloc_func, ple_mem_realloc_t **realloc_func, ple_mem_free_t **free_func)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_mem_functions_set</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>a6ceb5f2d75fe7e938852ba7df184aff9</anchor>
      <arglist>(ple_mem_malloc_t *malloc_func, ple_mem_realloc_t *realloc_func, ple_mem_free_t *free_func)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>ple_timer_wtime</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>a7abd7099c63967393121b740fd406e9b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>ple_timer_cpu_time</name>
      <anchorfile>ple__defs_8c.html</anchorfile>
      <anchor>ad95b1e8bad6caded50ed81fa614ed866</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ple_locator.c</name>
    <path>/home/D43345/Code_Saturne/saturne-4.1/libple/src/</path>
    <filename>ple__locator_8c</filename>
    <member kind="function">
      <type>ple_locator_t *</type>
      <name>ple_locator_create</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a72845c5260e19d64393e1e1c7bc5dac5</anchor>
      <arglist>(MPI_Comm comm, int n_ranks, int start_rank)</arglist>
    </member>
    <member kind="function">
      <type>ple_locator_t *</type>
      <name>ple_locator_destroy</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a30ae0cd7f9ea8c7cd2b0c8f177e0c2df</anchor>
      <arglist>(ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_set_mesh</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>af30f724ed8d046f0e44e4cc14b42d02b</anchor>
      <arglist>(ple_locator_t *this_locator, const void *mesh, const int *options, float tolerance_base, float tolerance_fraction, int dim, ple_lnum_t n_points, const ple_lnum_t point_list[], const ple_lnum_t point_tag[], const ple_coord_t point_coords[], float distance[], ple_mesh_extents_t *mesh_extents_f, ple_mesh_elements_locate_t *mesh_locate_f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_extend_search</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>aed5d7d3c4b10215959a937a908bfcd95</anchor>
      <arglist>(ple_locator_t *this_locator, const void *mesh, const int *options, float tolerance_base, float tolerance_fraction, ple_lnum_t n_points, const ple_lnum_t point_list[], const ple_lnum_t point_tag[], const ple_coord_t point_coords[], float distance[], ple_mesh_extents_t *mesh_extents_f, ple_mesh_elements_locate_t *mesh_locate_f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_shift_locations</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a2afaf989dcac8deec30874372aaf0a48</anchor>
      <arglist>(ple_locator_t *this_locator, ple_lnum_t location_shift)</arglist>
    </member>
    <member kind="function">
      <type>ple_lnum_t</type>
      <name>ple_locator_get_n_dist_points</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>ada3b75dbf577d3aa1e0993d5bc8df86f</anchor>
      <arglist>(const ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>const ple_lnum_t *</type>
      <name>ple_locator_get_dist_locations</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a192358f993ec96a8704545f0a30304cd</anchor>
      <arglist>(const ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>const ple_coord_t *</type>
      <name>ple_locator_get_dist_coords</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>ad8e3c18a775d23d0d3a271b784fdf26d</anchor>
      <arglist>(const ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>ple_lnum_t</type>
      <name>ple_locator_get_n_interior</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a7de7372beec3a14e460a6ca3c8a46d68</anchor>
      <arglist>(const ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>const ple_lnum_t *</type>
      <name>ple_locator_get_interior_list</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a1dd0d292dbb0fd6daa7d9844eb0cf2d9</anchor>
      <arglist>(const ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>ple_lnum_t</type>
      <name>ple_locator_get_n_exterior</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a77c3ce0ff0ed138282887739674f53f5</anchor>
      <arglist>(const ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>const ple_lnum_t *</type>
      <name>ple_locator_get_exterior_list</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>aea06f863879fc74c7db76466bb612846</anchor>
      <arglist>(const ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_discard_exterior</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a5f34b68fbaeefb82395c1de6be142d9a</anchor>
      <arglist>(ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_exchange_point_var</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a2fc310ddc3a95628111b2cb241899d65</anchor>
      <arglist>(ple_locator_t *this_locator, void *distant_var, void *local_var, const ple_lnum_t *local_list, size_t type_size, size_t stride, int reverse)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_get_times</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>ad327d488f7dc6d4b1fc79bf7b503383e</anchor>
      <arglist>(const ple_locator_t *this_locator, double *location_wtime, double *location_cpu_time, double *exchange_wtime, double *exchange_cpu_time)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_get_comm_times</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>ab9c09befdddb3c4def3a91c5a1a18f17</anchor>
      <arglist>(const ple_locator_t *this_locator, double *location_wtime, double *location_cpu_time, double *exchange_wtime, double *exchange_cpu_time)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_dump</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a8817489bb8eb60921a87997ea0045d78</anchor>
      <arglist>(const ple_locator_t *this_locator)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ple_locator_get_async_threshold</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a5d53c909923b62447d34b80a318cfd11</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_set_async_threshold</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>a5ad93a9246f4ef1d58f3008cd55c70b2</anchor>
      <arglist>(int threshold)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ple_locator_set_comm_log</name>
      <anchorfile>ple__locator_8c.html</anchorfile>
      <anchor>ab64edbd58568fb8bb57c1d0b3e6c437b</anchor>
      <arglist>(ple_locator_log_t *log_function, int start_p_comm, int end_p_comm, int start_g_comm, int end_g_comm)</arglist>
    </member>
  </compound>
  <compound kind="dir">
    <name>doc</name>
    <path>/home/D43345/Code_Saturne/saturne-4.1/libple/doc/</path>
    <filename>dir_e68e8157741866f444e17edd764ebbae.html</filename>
    <dir>doc/doxygen</dir>
  </compound>
  <compound kind="dir">
    <name>doc/doxygen</name>
    <path>/home/D43345/Code_Saturne/saturne-4.1/libple/doc/doxygen/</path>
    <filename>dir_04f2ecc425faf0d475a3caf484e551f3.html</filename>
    <file>mainpage.h</file>
  </compound>
  <compound kind="dir">
    <name>src</name>
    <path>/home/D43345/Code_Saturne/saturne-4.1/libple/src/</path>
    <filename>dir_68267d1309a1af8e8297ef4c3efbcdba.html</filename>
    <file>ple_config_defs.h</file>
    <file>ple_coupling.c</file>
    <file>ple_coupling.h</file>
    <file>ple_defs.c</file>
    <file>ple_defs.h</file>
    <file>ple_locator.c</file>
    <file>ple_locator.h</file>
  </compound>
  <compound kind="page">
    <name>index</name>
    <title>PLE (Parallel Location and Exchange) documentation</title>
    <filename>index</filename>
    <docanchor file="index">mainpage_ple</docanchor>
    <docanchor file="index" title="Introduction">intro</docanchor>
    <docanchor file="index" title="Coupling API">PLE</docanchor>
  </compound>
</tagfile>
